<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GroupMessage extends Model
{
    protected $table = 'group_messages';
    protected $primaryKey = 'Group_message_id';
    public $timestamps = true;

    const CREATED_AT = 'Sent_at';
    const UPDATED_AT = 'Updated_at';

    protected $fillable = [
        'Group_id',
        'Sender_id',
        'Content',
    ];

    protected $casts = [
        'Sent_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function sender()
    {
        return $this->belongsTo(User::class, 'Sender_id', 'User_id');
    }

    public function group()
    {
        return $this->belongsTo(Group::class, 'Group_id', 'Group_id');
    }
}
